using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ConsoleApp153
{
    internal class Program
    {
        class VanOgranicenja : ArgumentException
        {
            public VanOgranicenja(string poruka) : base(poruka) { }
        }
        static void Main(string[] args)
        {
            try
            {
                string[] s = Console.ReadLine().Split();
                int[] jabuke = new int[3];
                for (int i = 0; i < 3; i++)
                {
                    jabuke[i] = int.Parse(s[i]);
                    if ((jabuke[i] < 0) || (jabuke[i] > 1000000000))
                    {
                        throw new VanOgranicenja("Unos je va ogranicenja (0 <= a,b,c >= 1000000000).");
                    }
                }
                Array.Sort(jabuke);

                if ((jabuke[1] - jabuke[0]) % 3 == 0 && (jabuke[2] - jabuke[1]) % 3 == 0)
                {
                    Console.WriteLine("DA");
                }
                else
                {
                    Console.WriteLine("NE");
                }
                Console.ReadKey();
            }
            catch (ArgumentException ae)
            {
                Console.WriteLine("Detalji greške: " + ae.Message);
            }
            catch(Exception e)
            {
                Console.WriteLine("Desila se neocekivana greška.");
                Console.WriteLine("Detalji greške: " + e.Message);
            }
        }
    }
}